/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.DaggerCollections;
import dagger.internal.Factory;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;

public final class SetFactory<T>
implements Factory<Set<T>> {
    private static final Factory<Set<Object>> EMPTY_FACTORY = InstanceFactory.create(Collections.emptySet());
    private final List<Provider<T>> individualProviders;
    private final List<Provider<Collection<T>>> collectionProviders;

    public static <T> Factory<Set<T>> empty() {
        return EMPTY_FACTORY;
    }

    public static <T> Builder<T> builder(int n, int n2) {
        return new Builder(n, n2);
    }

    private SetFactory(List<Provider<T>> list, List<Provider<Collection<T>>> list2) {
        this.individualProviders = list;
        this.collectionProviders = list2;
    }

    @Override
    public Set<T> get() {
        int n = this.individualProviders.size();
        ArrayList<Collection<T>> arrayList = new ArrayList<Collection<T>>(this.collectionProviders.size());
        int n2 = this.collectionProviders.size();
        for (int i = 0; i < n2; ++i) {
            Collection<T> collection = this.collectionProviders.get(i).get();
            n += collection.size();
            arrayList.add(collection);
        }
        HashSet hashSet = DaggerCollections.newHashSetWithExpectedSize(n);
        int n3 = this.individualProviders.size();
        for (n2 = 0; n2 < n3; ++n2) {
            hashSet.add(Preconditions.checkNotNull(this.individualProviders.get(n2).get()));
        }
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            for (Object e : (Collection)arrayList.get(n2)) {
                hashSet.add(Preconditions.checkNotNull(e));
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static final class Builder<T> {
        private final List<Provider<T>> individualProviders;
        private final List<Provider<Collection<T>>> collectionProviders;

        private Builder(int n, int n2) {
            this.individualProviders = DaggerCollections.presizedList(n);
            this.collectionProviders = DaggerCollections.presizedList(n2);
        }

        public Builder<T> addProvider(Provider<? extends T> provider) {
            assert (provider != null) : "Codegen error? Null provider";
            this.individualProviders.add(provider);
            return this;
        }

        public Builder<T> addCollectionProvider(Provider<? extends Collection<? extends T>> provider) {
            assert (provider != null) : "Codegen error? Null provider";
            this.collectionProviders.add(provider);
            return this;
        }

        public SetFactory<T> build() {
            assert (!DaggerCollections.hasDuplicates(this.individualProviders)) : "Codegen error?  Duplicates in the provider list";
            assert (!DaggerCollections.hasDuplicates(this.collectionProviders)) : "Codegen error?  Duplicates in the provider list";
            return new SetFactory(this.individualProviders, this.collectionProviders);
        }
    }
}

