/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.util.win;

import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtil {
    private static final int HKEY_CURRENT_USER = -2147483647;
    private static final int KEY_WRITE = 131078;
    private static final String WINDOWS_REG_CLOSE_KEY = "WindowsRegCloseKey";
    private static final String WINDOWS_REG_CREATE_KEY_EX = "WindowsRegCreateKeyEx";
    private static final String WINDOWS_REG_OPEN_KEY = "WindowsRegOpenKey";
    private static final String WINDOWS_REG_SET_VALUE_EX = "WindowsRegSetValueEx";
    private static Logger _logger = LoggerFactory.getLogger(RegistryUtil.class.getName());
    private static Class<? extends Preferences> _clazz = null;
    private static Preferences _userRoot = null;

    public static boolean writeRegistry(String string, String string2, int n) {
        return RegistryUtil.writeRegistry(string, string2, String.valueOf(n));
    }

    public static boolean writeRegistry(String string, String string2, String string3) {
        try {
            RegistryUtil._init();
            boolean bl = RegistryUtil._regCreateKeyEx(string);
            if (!bl) {
                return false;
            }
            int n = RegistryUtil._regOpenKeyToWrite(string);
            if (n == 0) {
                return false;
            }
            boolean bl2 = RegistryUtil._regSetStringValueEx(n, string2, string3);
            if (!RegistryUtil._regCloseKey(n)) {
                return false;
            }
            return bl2;
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            return false;
        }
    }

    private static void _init() {
        if (_userRoot == null) {
            _userRoot = Preferences.userRoot();
        }
        if (_clazz == null) {
            _clazz = _userRoot.getClass();
        }
    }

    private static boolean _regCloseKey(int n) throws Exception {
        Method method = _clazz.getDeclaredMethod(WINDOWS_REG_CLOSE_KEY, Integer.TYPE);
        method.setAccessible(true);
        method.invoke((Object)_userRoot, n);
        return true;
    }

    private static boolean _regCreateKeyEx(String string) throws Exception {
        Method method = _clazz.getDeclaredMethod(WINDOWS_REG_CREATE_KEY_EX, Integer.TYPE, byte[].class);
        method.setAccessible(true);
        Object object = method.invoke((Object)_userRoot, -2147483647, RegistryUtil._stringToByteArray(string));
        if (object == null) {
            return false;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            if (nArray.length == 0) {
                return false;
            }
            return RegistryUtil._regCloseKey(nArray[0]);
        }
        return false;
    }

    private static int _regOpenKeyToWrite(String string) throws Exception {
        Method method = _clazz.getDeclaredMethod(WINDOWS_REG_OPEN_KEY, Integer.TYPE, byte[].class, Integer.TYPE);
        method.setAccessible(true);
        Object object = method.invoke((Object)_userRoot, -2147483647, RegistryUtil._stringToByteArray(string), 131078);
        if (object == null) {
            return 0;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            if (nArray.length == 0) {
                return 0;
            }
            return nArray[0];
        }
        return 0;
    }

    private static boolean _regSetStringValueEx(int n, String string, String string2) throws Exception {
        Method method = _clazz.getDeclaredMethod(WINDOWS_REG_SET_VALUE_EX, Integer.TYPE, byte[].class, byte[].class);
        method.setAccessible(true);
        Object object = method.invoke((Object)_userRoot, n, RegistryUtil._stringToByteArray(string), RegistryUtil._stringToByteArray(string2));
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            if (n2 == 0) {
                return true;
            }
            _logger.error("Unable to set registry value {} {}", (Object)string, (Object)n2);
        }
        return false;
    }

    private static byte[] _stringToByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }
}

