/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.contextmenu.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ContextMenuItem {
    private static final String _SEPARATOR = "_SEPARATOR_";
    private ContextMenuAction _contextMenuAction;
    private List<ContextMenuItem> _contextMenuItems;
    private boolean _enabled;
    private String _helpText = "";
    private String _iconId = "";
    private String _iconPath = "";
    private String _title = "";
    private String _uuid = "";

    public ContextMenuItem(String string) {
        this._title = string;
        this._contextMenuItems = new ArrayList<ContextMenuItem>();
        this._enabled = true;
        this._uuid = UUID.randomUUID().toString();
    }

    public ContextMenuItem(String string, ContextMenuItem contextMenuItem) {
        this(string);
        contextMenuItem.addContextMenuItem(this);
    }

    public boolean addContextMenuItem(ContextMenuItem contextMenuItem) {
        return this._contextMenuItems.add(contextMenuItem);
    }

    public void addContextMenuItem(ContextMenuItem contextMenuItem, int n) {
        this._contextMenuItems.add(n, contextMenuItem);
    }

    public boolean addSeparator() {
        return this._contextMenuItems.add(ContextMenuItem._getSeparator());
    }

    public void addSeparator(int n) {
        this._contextMenuItems.add(n, ContextMenuItem._getSeparator());
    }

    public void fireContextMenuAction(String[] stringArray) {
        if (this._contextMenuAction != null) {
            this._contextMenuAction.onSelection(stringArray);
        }
    }

    @JsonIgnore
    public List<ContextMenuItem> getAllContextMenuItems() {
        ArrayList<ContextMenuItem> arrayList = new ArrayList<ContextMenuItem>();
        arrayList.add(this);
        this._addChildren(this, arrayList);
        return arrayList;
    }

    public List<ContextMenuItem> getContextMenuItems() {
        return this._contextMenuItems;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public String getHelpText() {
        return this._helpText;
    }

    @Deprecated
    public String getIconId() {
        return this._iconId;
    }

    public String getIconPath() {
        return this._iconPath;
    }

    public String getTitle() {
        return this._title;
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean removeContextMenuItem(ContextMenuItem contextMenuItem) {
        return this._contextMenuItems.remove(contextMenuItem);
    }

    public void setContextMenuAction(ContextMenuAction contextMenuAction) {
        this._contextMenuAction = contextMenuAction;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public void setHelpText(String string) {
        this._helpText = string;
    }

    @Deprecated
    public void setIconId(String string) {
        this._iconId = string;
    }

    public void setIconPath(String string) {
        this._iconPath = string;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String toString() {
        return this._title + " (" + this._uuid + ") " + this._contextMenuItems.size();
    }

    private static ContextMenuItem _getSeparator() {
        return new ContextMenuItem(_SEPARATOR);
    }

    private void _addChildren(ContextMenuItem contextMenuItem, List<ContextMenuItem> list) {
        for (ContextMenuItem contextMenuItem2 : contextMenuItem.getContextMenuItems()) {
            list.add(contextMenuItem2);
            this._addChildren(contextMenuItem2, list);
        }
    }
}

