/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.win;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessor
implements Runnable {
    private static Logger _logger = LoggerFactory.getLogger(MessageProcessor.class.getName());
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private Socket _clientSocket;
    private InputStreamReader _inputStreamReader;
    private NativityControl _nativityControl;
    private OutputStreamWriter _outputStreamWriter;

    public MessageProcessor(Socket socket, NativityControl nativityControl) {
        this._clientSocket = socket;
        this._nativityControl = nativityControl;
    }

    @Override
    public void run() {
        this._init();
        try {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = this._inputStreamReader.read()) != -1) {
                stringBuilder.append((char)n);
            }
            String string = stringBuilder.toString();
            if (string.isEmpty()) {
                this._returnEmpty();
            } else {
                this._handle(string);
            }
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
        }
        finally {
            try {
                this._inputStreamReader.close();
            }
            catch (Exception exception) {
                _logger.error(exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handle(String string) throws IOException {
        try {
            NativityMessage nativityMessage = _objectMapper.readValue(string, NativityMessage.class);
            NativityMessage nativityMessage2 = this._nativityControl.fireMessage(nativityMessage);
            if (nativityMessage2 == null) {
                this._returnEmpty();
            } else {
                _objectMapper.writeValue(this._outputStreamWriter, (Object)nativityMessage2);
                this._outputStreamWriter.write("\u0000");
            }
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
        }
        finally {
            if (!this._clientSocket.isOutputShutdown()) {
                this._outputStreamWriter.close();
            }
        }
    }

    private void _init() {
        try {
            this._inputStreamReader = new InputStreamReader(this._clientSocket.getInputStream(), Charset.forName("UTF-16LE"));
            this._outputStreamWriter = new OutputStreamWriter(this._clientSocket.getOutputStream(), Charset.forName("UTF-16LE"));
        }
        catch (IOException iOException) {
            _logger.error(iOException.getMessage(), iOException);
        }
    }

    private void _returnEmpty() {
        try {
            this._outputStreamWriter.close();
        }
        catch (IOException iOException) {
            _logger.error(iOException.getMessage(), iOException);
        }
    }
}

