/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.findersync;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSNativityControlImpl
extends NativityControl {
    private static final byte[] _RETURN_NEW_LINE = "\r\n".getBytes();
    private static Logger _logger = LoggerFactory.getLogger(FSNativityControlImpl.class.getName());
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private ChannelGroup _channelGroup = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    private EventLoopGroup _childEventLoopGroup;
    private boolean _connected;
    private List<FinderSyncChannelHandler> _finderSyncChannelHandlers = new ArrayList<FinderSyncChannelHandler>();
    private EventLoopGroup _parentEventLoopGroup;
    private String _portFilePath;

    @Override
    public void addFavoritesPath(String string) {
        NativityMessage nativityMessage = new NativityMessage("addFavoritesPath", string);
        this.sendMessage(nativityMessage);
    }

    @Override
    public boolean connect() {
        if (this._connected) {
            return true;
        }
        this._childEventLoopGroup = new NioEventLoopGroup();
        this._parentEventLoopGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            serverBootstrap.group(this._parentEventLoopGroup, this._childEventLoopGroup);
            serverBootstrap.channel(NioServerSocketChannel.class);
            ChannelInitializer<SocketChannel> channelInitializer = new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    DelimiterBasedFrameDecoder delimiterBasedFrameDecoder = new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, Delimiters.lineDelimiter());
                    FinderSyncChannelHandler finderSyncChannelHandler = new FinderSyncChannelHandler();
                    socketChannel.pipeline().addLast(delimiterBasedFrameDecoder, finderSyncChannelHandler);
                }
            };
            serverBootstrap.childHandler(channelInitializer);
            serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, true);
            ChannelFuture channelFuture = serverBootstrap.bind(0).sync();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)channelFuture.channel().localAddress();
            this._writePortToFile(inetSocketAddress.getPort());
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            this._connected = false;
            return false;
        }
        this._connected = true;
        return true;
    }

    @Override
    public boolean disconnect() {
        if (!this._connected) {
            return true;
        }
        this._childEventLoopGroup.shutdownGracefully();
        this._parentEventLoopGroup.shutdownGracefully();
        this._connected = false;
        return true;
    }

    @Override
    public Set<String> getAllObservedFolders() {
        HashSet<String> hashSet = new HashSet<String>();
        for (FinderSyncChannelHandler finderSyncChannelHandler : this._finderSyncChannelHandlers) {
            hashSet.addAll(finderSyncChannelHandler.getObservedFolders());
        }
        return hashSet;
    }

    @Override
    public boolean load() throws Exception {
        return true;
    }

    @Override
    public boolean loaded() {
        return true;
    }

    @Override
    public void refreshFiles(String[] stringArray) {
    }

    @Override
    public void removeFavoritesPath(String string) {
        NativityMessage nativityMessage = new NativityMessage("removeFavoritesPath", string);
        this.sendMessage(nativityMessage);
    }

    @Override
    public String sendMessage(NativityMessage nativityMessage) {
        try {
            byte[] byArray = _objectMapper.writeValueAsBytes(nativityMessage);
            ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray, _RETURN_NEW_LINE);
            this._channelGroup.writeAndFlush(byteBuf);
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
        }
        return "";
    }

    @Override
    public void setFilterFolder(String string) {
        this.setFilterFolders(new String[]{string});
    }

    @Override
    public void setFilterFolders(String[] stringArray) {
        NativityMessage nativityMessage = new NativityMessage("setFilterPaths", stringArray);
        this.sendMessage(nativityMessage);
    }

    @Override
    public void setPortFilePath(String string) {
        this._portFilePath = string;
    }

    @Override
    public void setSystemFolder(String string) {
    }

    @Override
    public boolean unload() throws Exception {
        return false;
    }

    private void _writePortToFile(int n) {
        String string = null;
        string = this._portFilePath == null ? System.getProperty("user.home") + "/.liferay-nativity/port" : this._portFilePath;
        final File file = new File(string);
        PrintWriter printWriter = null;
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            printWriter = new PrintWriter(string);
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            return;
        }
        printWriter.println(String.valueOf(n));
        printWriter.close();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    _logger.error(exception.getMessage(), exception);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
    }

    private class FinderSyncChannelHandler
    extends ChannelInboundHandlerAdapter {
        private Set<String> _observedFolders = Collections.newSetFromMap(new ConcurrentHashMap());

        private FinderSyncChannelHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            super.channelActive(channelHandlerContext);
            FSNativityControlImpl.this._finderSyncChannelHandlers.add(this);
            FSNativityControlImpl.this._channelGroup.add(channelHandlerContext.channel());
            FSNativityControlImpl.this.fireSocketOpenListeners();
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            super.channelInactive(channelHandlerContext);
            FSNativityControlImpl.this._finderSyncChannelHandlers.remove(this);
            FSNativityControlImpl.this._channelGroup.remove(channelHandlerContext.channel());
            FSNativityControlImpl.this.fireSocketCloseListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            NativityMessage nativityMessage;
            ByteBuf byteBuf;
            block11: {
                block10: {
                    String string;
                    block9: {
                        byteBuf = (ByteBuf)object;
                        string = byteBuf.toString(CharsetUtil.UTF_8);
                        if (!string.isEmpty()) break block9;
                        byteBuf.release();
                        return;
                    }
                    nativityMessage = _objectMapper.readValue(string, NativityMessage.class);
                    if (!nativityMessage.getCommand().equals("startObservingFolder")) break block10;
                    this._observedFolders.add(nativityMessage.getValue().toString());
                    byteBuf.release();
                    return;
                }
                if (!nativityMessage.getCommand().equals("endObservingFolder")) break block11;
                this._observedFolders.remove(nativityMessage.getValue().toString());
                byteBuf.release();
                return;
            }
            try {
                try {
                    NativityMessage nativityMessage2 = FSNativityControlImpl.this.fireMessage(nativityMessage);
                    if (nativityMessage2 != null) {
                        byte[] byArray = _objectMapper.writeValueAsBytes(nativityMessage2);
                        ByteBuf byteBuf2 = Unpooled.wrappedBuffer(byArray, _RETURN_NEW_LINE);
                        channelHandlerContext.writeAndFlush(byteBuf2);
                    }
                }
                catch (Exception exception) {
                    _logger.error(exception.getMessage(), exception);
                }
            }
            finally {
                byteBuf.release();
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            _logger.error(throwable.getMessage(), throwable);
            channelHandlerContext.close();
            FSNativityControlImpl.this.fireSocketCloseListeners();
        }

        public Set<String> getObservedFolders() {
            return this._observedFolders;
        }
    }
}

