/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SpinnerToValueModelConnector {
    private final SpinnerModel spinnerModel;
    private final ValueModel valueModel;
    private final Object defaultValue;
    private final UpdateHandler updateHandler;

    public SpinnerToValueModelConnector(SpinnerModel spinnerModel, ValueModel valueModel, Object object) {
        if (spinnerModel == null) {
            throw new NullPointerException("The spinner model must not be null.");
        }
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        if (object == null) {
            throw new NullPointerException("The default value must not be null.");
        }
        this.spinnerModel = spinnerModel;
        this.valueModel = valueModel;
        this.defaultValue = object;
        this.updateHandler = new UpdateHandler();
        spinnerModel.addChangeListener(this.updateHandler);
        valueModel.addValueChangeListener(this.updateHandler);
    }

    public static void connect(SpinnerModel spinnerModel, ValueModel valueModel, Object object) {
        new SpinnerToValueModelConnector(spinnerModel, valueModel, object);
    }

    public void updateSpinnerModel() {
        Object object = this.valueModel.getValue();
        Object object2 = object != null ? object : this.defaultValue;
        this.setSpinnerModelValueSilently(object2);
    }

    public void updateValueModel() {
        this.setValueModelValueSilently(this.spinnerModel.getValue());
    }

    private void setSpinnerModelValueSilently(Object object) {
        this.spinnerModel.removeChangeListener(this.updateHandler);
        this.spinnerModel.setValue(object);
        this.spinnerModel.addChangeListener(this.updateHandler);
    }

    private void setValueModelValueSilently(Object object) {
        this.valueModel.removeValueChangeListener(this.updateHandler);
        this.valueModel.setValue(object);
        this.valueModel.addValueChangeListener(this.updateHandler);
    }

    public void release() {
        this.spinnerModel.removeChangeListener(this.updateHandler);
        this.valueModel.removeValueChangeListener(this.updateHandler);
    }

    private final class UpdateHandler
    implements PropertyChangeListener,
    ChangeListener {
        private UpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SpinnerToValueModelConnector.this.updateSpinnerModel();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SpinnerToValueModelConnector.this.updateValueModel();
        }
    }
}

