/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.SingleFieldBuilderV3;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RepeatedFieldBuilderV3<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
implements AbstractMessage.BuilderParent {
    private AbstractMessage.BuilderParent parent;
    private List<MType> messages;
    private boolean isMessagesListMutable;
    private List<SingleFieldBuilderV3<MType, BType, IType>> builders;
    private boolean isClean;
    private MessageExternalList<MType, BType, IType> externalMessageList;
    private BuilderExternalList<MType, BType, IType> externalBuilderList;
    private MessageOrBuilderExternalList<MType, BType, IType> externalMessageOrBuilderList;

    public RepeatedFieldBuilderV3(List<MType> list, boolean bl, AbstractMessage.BuilderParent builderParent, boolean bl2) {
        this.messages = list;
        this.isMessagesListMutable = bl;
        this.parent = builderParent;
        this.isClean = bl2;
    }

    public void dispose() {
        this.parent = null;
    }

    private void ensureMutableMessageList() {
        if (!this.isMessagesListMutable) {
            this.messages = new ArrayList<MType>(this.messages);
            this.isMessagesListMutable = true;
        }
    }

    private void ensureBuilders() {
        if (this.builders == null) {
            this.builders = new ArrayList<SingleFieldBuilderV3<MType, BType, IType>>(this.messages.size());
            for (int i = 0; i < this.messages.size(); ++i) {
                this.builders.add(null);
            }
        }
    }

    public int getCount() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public MType getMessage(int n) {
        return this.getMessage(n, false);
    }

    private MType getMessage(int n, boolean bl) {
        if (this.builders == null) {
            return (MType)((AbstractMessage)this.messages.get(n));
        }
        SingleFieldBuilderV3<MType, BType, IType> singleFieldBuilderV3 = this.builders.get(n);
        if (singleFieldBuilderV3 == null) {
            return (MType)((AbstractMessage)this.messages.get(n));
        }
        return bl ? singleFieldBuilderV3.build() : singleFieldBuilderV3.getMessage();
    }

    public BType getBuilder(int n) {
        this.ensureBuilders();
        SingleFieldBuilderV3<Object, BType, IType> singleFieldBuilderV3 = this.builders.get(n);
        if (singleFieldBuilderV3 == null) {
            AbstractMessage abstractMessage = (AbstractMessage)this.messages.get(n);
            singleFieldBuilderV3 = new SingleFieldBuilderV3(abstractMessage, this, this.isClean);
            this.builders.set(n, singleFieldBuilderV3);
        }
        return singleFieldBuilderV3.getBuilder();
    }

    public IType getMessageOrBuilder(int n) {
        if (this.builders == null) {
            return (IType)((MessageOrBuilder)this.messages.get(n));
        }
        SingleFieldBuilderV3<MType, BType, IType> singleFieldBuilderV3 = this.builders.get(n);
        if (singleFieldBuilderV3 == null) {
            return (IType)((MessageOrBuilder)this.messages.get(n));
        }
        return singleFieldBuilderV3.getMessageOrBuilder();
    }

    public RepeatedFieldBuilderV3<MType, BType, IType> setMessage(int n, MType MType) {
        SingleFieldBuilderV3 singleFieldBuilderV3;
        Internal.checkNotNull(MType);
        this.ensureMutableMessageList();
        this.messages.set(n, MType);
        if (this.builders != null && (singleFieldBuilderV3 = (SingleFieldBuilderV3)this.builders.set(n, null)) != null) {
            singleFieldBuilderV3.dispose();
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilderV3<MType, BType, IType> addMessage(MType MType) {
        Internal.checkNotNull(MType);
        this.ensureMutableMessageList();
        this.messages.add(MType);
        if (this.builders != null) {
            this.builders.add(null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilderV3<MType, BType, IType> addMessage(int n, MType MType) {
        Internal.checkNotNull(MType);
        this.ensureMutableMessageList();
        this.messages.add(n, MType);
        if (this.builders != null) {
            this.builders.add(n, null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilderV3<MType, BType, IType> addAllMessages(Iterable<? extends MType> iterable) {
        for (Object object : iterable) {
            Internal.checkNotNull(object);
        }
        int n = -1;
        if (iterable instanceof Collection) {
            Object object;
            object = (Collection)iterable;
            if (object.size() == 0) {
                return this;
            }
            n = object.size();
        }
        this.ensureMutableMessageList();
        if (n >= 0 && this.messages instanceof ArrayList) {
            ((ArrayList)this.messages).ensureCapacity(this.messages.size() + n);
        }
        for (AbstractMessage abstractMessage : iterable) {
            this.addMessage(abstractMessage);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public BType addBuilder(MType MType) {
        this.ensureMutableMessageList();
        this.ensureBuilders();
        SingleFieldBuilderV3 singleFieldBuilderV3 = new SingleFieldBuilderV3(MType, this, this.isClean);
        this.messages.add(null);
        this.builders.add(singleFieldBuilderV3);
        this.onChanged();
        this.incrementModCounts();
        return singleFieldBuilderV3.getBuilder();
    }

    public BType addBuilder(int n, MType MType) {
        this.ensureMutableMessageList();
        this.ensureBuilders();
        SingleFieldBuilderV3 singleFieldBuilderV3 = new SingleFieldBuilderV3(MType, this, this.isClean);
        this.messages.add(n, null);
        this.builders.add(n, singleFieldBuilderV3);
        this.onChanged();
        this.incrementModCounts();
        return singleFieldBuilderV3.getBuilder();
    }

    public void remove(int n) {
        SingleFieldBuilderV3<MType, BType, IType> singleFieldBuilderV3;
        this.ensureMutableMessageList();
        this.messages.remove(n);
        if (this.builders != null && (singleFieldBuilderV3 = this.builders.remove(n)) != null) {
            singleFieldBuilderV3.dispose();
        }
        this.onChanged();
        this.incrementModCounts();
    }

    public void clear() {
        this.messages = Collections.emptyList();
        this.isMessagesListMutable = false;
        if (this.builders != null) {
            for (SingleFieldBuilderV3<MType, BType, IType> singleFieldBuilderV3 : this.builders) {
                if (singleFieldBuilderV3 == null) continue;
                singleFieldBuilderV3.dispose();
            }
            this.builders = null;
        }
        this.onChanged();
        this.incrementModCounts();
    }

    public List<MType> build() {
        int n;
        this.isClean = true;
        if (!this.isMessagesListMutable && this.builders == null) {
            return this.messages;
        }
        boolean bl = true;
        if (!this.isMessagesListMutable) {
            for (n = 0; n < this.messages.size(); ++n) {
                Message message = (Message)this.messages.get(n);
                SingleFieldBuilderV3<MType, BType, IType> singleFieldBuilderV3 = this.builders.get(n);
                if (singleFieldBuilderV3 == null || singleFieldBuilderV3.build() == message) continue;
                bl = false;
                break;
            }
            if (bl) {
                return this.messages;
            }
        }
        this.ensureMutableMessageList();
        for (n = 0; n < this.messages.size(); ++n) {
            this.messages.set(n, this.getMessage(n, true));
        }
        this.messages = Collections.unmodifiableList(this.messages);
        this.isMessagesListMutable = false;
        return this.messages;
    }

    public List<MType> getMessageList() {
        if (this.externalMessageList == null) {
            this.externalMessageList = new MessageExternalList(this);
        }
        return this.externalMessageList;
    }

    public List<BType> getBuilderList() {
        if (this.externalBuilderList == null) {
            this.externalBuilderList = new BuilderExternalList(this);
        }
        return this.externalBuilderList;
    }

    public List<IType> getMessageOrBuilderList() {
        if (this.externalMessageOrBuilderList == null) {
            this.externalMessageOrBuilderList = new MessageOrBuilderExternalList(this);
        }
        return this.externalMessageOrBuilderList;
    }

    private void onChanged() {
        if (this.isClean && this.parent != null) {
            this.parent.markDirty();
            this.isClean = false;
        }
    }

    @Override
    public void markDirty() {
        this.onChanged();
    }

    private void incrementModCounts() {
        if (this.externalMessageList != null) {
            this.externalMessageList.incrementModCount();
        }
        if (this.externalBuilderList != null) {
            this.externalBuilderList.incrementModCount();
        }
        if (this.externalMessageOrBuilderList != null) {
            this.externalMessageOrBuilderList.incrementModCount();
        }
    }

    private static class MessageOrBuilderExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<IType>
    implements List<IType> {
        RepeatedFieldBuilderV3<MType, BType, IType> builder;

        MessageOrBuilderExternalList(RepeatedFieldBuilderV3<MType, BType, IType> repeatedFieldBuilderV3) {
            this.builder = repeatedFieldBuilderV3;
        }

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public IType get(int n) {
            return this.builder.getMessageOrBuilder(n);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }

    private static class BuilderExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<BType>
    implements List<BType> {
        RepeatedFieldBuilderV3<MType, BType, IType> builder;

        BuilderExternalList(RepeatedFieldBuilderV3<MType, BType, IType> repeatedFieldBuilderV3) {
            this.builder = repeatedFieldBuilderV3;
        }

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public BType get(int n) {
            return this.builder.getBuilder(n);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }

    private static class MessageExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<MType>
    implements List<MType> {
        RepeatedFieldBuilderV3<MType, BType, IType> builder;

        MessageExternalList(RepeatedFieldBuilderV3<MType, BType, IType> repeatedFieldBuilderV3) {
            this.builder = repeatedFieldBuilderV3;
        }

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public MType get(int n) {
            return this.builder.getMessage(n);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }
}

