/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.primitives.Longs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class LittleEndianByteArray {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] byArray, int n) {
        assert (byArray.length >= n + 8);
        return byteArray.getLongLittleEndian(byArray, n);
    }

    static long load64Safely(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = Math.min(n2, 8);
        for (int i = 0; i < n3; ++i) {
            l |= ((long)byArray[n + i] & 0xFFL) << i * 8;
        }
        return l;
    }

    static void store64(byte[] byArray, int n, long l) {
        assert (n >= 0 && n + 8 <= byArray.length);
        byteArray.putLongLittleEndian(byArray, n, l);
    }

    static int load32(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    static {
        Enum enum_ = JavaLittleEndianBytes.INSTANCE;
        try {
            String string = System.getProperty("os.arch");
            if ("amd64".equals(string) || "aarch64".equals(string)) {
                enum_ = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteArray = enum_;
    }

    private static enum JavaLittleEndianBytes implements LittleEndianBytes
    {
        INSTANCE{

            @Override
            public long getLongLittleEndian(byte[] byArray, int n) {
                return Longs.fromBytes(byArray[n + 7], byArray[n + 6], byArray[n + 5], byArray[n + 4], byArray[n + 3], byArray[n + 2], byArray[n + 1], byArray[n]);
            }

            @Override
            public void putLongLittleEndian(byte[] byArray, int n, long l) {
                long l2 = 255L;
                for (int i = 0; i < 8; ++i) {
                    byArray[n + i] = (byte)((l & l2) >> i * 8);
                    l2 <<= 8;
                }
            }
        };

    }

    private static enum UnsafeByteArray implements LittleEndianBytes
    {
        UNSAFE_LITTLE_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] byArray, int n) {
                return theUnsafe.getLong(byArray, (long)n + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            @Override
            public void putLongLittleEndian(byte[] byArray, int n, long l) {
                theUnsafe.putLong(byArray, (long)n + (long)BYTE_ARRAY_BASE_OFFSET, l);
            }
        }
        ,
        UNSAFE_BIG_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] byArray, int n) {
                long l = theUnsafe.getLong(byArray, (long)n + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes(l);
            }

            @Override
            public void putLongLittleEndian(byte[] byArray, int n, long l) {
                long l2 = Long.reverseBytes(l);
                theUnsafe.putLong(byArray, (long)n + (long)BYTE_ARRAY_BASE_OFFSET, l2);
            }
        };

        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            for (Field field : clazz.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!clazz.isInstance(object)) continue;
                                return (Unsafe)clazz.cast(object);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
        }

        static {
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }
}

