/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Set;

public class BeanAsArrayDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;

    public BeanAsArrayDeserializer(BeanDeserializerBase beanDeserializerBase, SettableBeanProperty[] settableBeanPropertyArray) {
        super(beanDeserializerBase);
        this._delegate = beanDeserializerBase;
        this._orderedProperties = settableBeanPropertyArray;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return this._delegate.unwrappingDeserializer(nameTransformer);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanAsArrayDeserializer(this._delegate.withObjectIdReader(objectIdReader), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withIgnorableProperties(Set<String> set) {
        return new BeanAsArrayDeserializer(this._delegate.withIgnorableProperties(set), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        return new BeanAsArrayDeserializer(this._delegate.withBeanProperties(beanPropertyMap), this._orderedProperties);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(jsonParser, deserializationContext);
        }
        if (!this._vanillaProcessing) {
            return this._deserializeNonVanilla(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        jsonParser.setCurrentValue(object);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n;
        }
        if (!this._ignoreAllUnknown) {
            deserializationContext.reportWrongTokenException(jsonParser, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", n2);
        }
        do {
            jsonParser.skipChildren();
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return object;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        jsonParser.setCurrentValue(object);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n;
        }
        if (!this._ignoreAllUnknown) {
            deserializationContext.reportWrongTokenException(jsonParser, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", n2);
        }
        do {
            jsonParser.skipChildren();
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return object;
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserializeFromNonArray(jsonParser, deserializationContext);
    }

    protected Object _deserializeNonVanilla(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._nonStandardCreation) {
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        jsonParser.setCurrentValue(object);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            ++n;
            if (settableBeanProperty != null && (clazz == null || settableBeanProperty.visibleInView(clazz))) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
                continue;
            }
            jsonParser.skipChildren();
        }
        if (!this._ignoreAllUnknown) {
            deserializationContext.reportWrongTokenException(jsonParser, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", n2);
        }
        do {
            jsonParser.skipChildren();
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return object;
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = settableBeanPropertyArray.length;
        int n2 = 0;
        Object object = null;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            block17: {
                SettableBeanProperty settableBeanProperty;
                SettableBeanProperty settableBeanProperty2 = settableBeanProperty = n2 < n ? settableBeanPropertyArray[n2] : null;
                if (settableBeanProperty == null) {
                    jsonParser.skipChildren();
                } else if (object != null) {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                    }
                } else {
                    String string = settableBeanProperty.getName();
                    SettableBeanProperty settableBeanProperty3 = propertyBasedCreator.findCreatorProperty(string);
                    if (settableBeanProperty3 != null) {
                        if (propertyValueBuffer.assignParameter(settableBeanProperty3, settableBeanProperty3.deserialize(jsonParser, deserializationContext))) {
                            try {
                                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), string, deserializationContext);
                                break block17;
                            }
                            jsonParser.setCurrentValue(object);
                            if (object.getClass() != this._beanType.getRawClass()) {
                                deserializationContext.reportMappingException("Can not support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", this._beanType.getRawClass().getName(), object.getClass().getName());
                            }
                        }
                    } else if (!propertyValueBuffer.readIdProperty(string)) {
                        propertyValueBuffer.bufferProperty(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext));
                    }
                }
            }
            ++n2;
        }
        if (object == null) {
            try {
                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
            }
            catch (Exception exception) {
                return this.wrapInstantiationProblem(exception, deserializationContext);
            }
        }
        return object;
    }

    protected Object _deserializeFromNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser.getCurrentToken(), jsonParser, "Can not deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array", new Object[]{this._beanType.getRawClass().getName(), jsonParser.getCurrentToken()});
    }
}

