/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.deser.BasicDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.impl.NoClassDefFoundDeserializer;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.deser.impl.SetterlessProperty;
import com.fasterxml.jackson.databind.deser.std.ThrowableDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanDeserializerFactory
extends BasicDeserializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    private static final Class<?>[] NO_VIEWS = new Class[0];
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(new DeserializerFactoryConfig());

    public BeanDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        super(deserializerFactoryConfig);
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactoryConfig deserializerFactoryConfig) {
        if (this._factoryConfig == deserializerFactoryConfig) {
            return this;
        }
        if (this.getClass() != BeanDeserializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanDeserializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalDeserializers': can not instantiate subtype with " + "additional deserializer definitions");
        }
        return new BeanDeserializerFactory(deserializerFactoryConfig);
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JsonDeserializer<Object> jsonDeserializer2 = this._findCustomBeanDeserializer(javaType, deserializationConfig, beanDescription);
        if (jsonDeserializer2 != null) {
            return jsonDeserializer2;
        }
        if (javaType.isThrowable()) {
            return this.buildThrowableDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (javaType.isAbstract() && !javaType.isPrimitive() && !javaType.isEnumType() && (jsonDeserializer = this.materializeAbstractType(deserializationContext, javaType, beanDescription)) != null) {
            beanDescription = deserializationConfig.introspect((JavaType)((Object)jsonDeserializer));
            return this.buildBeanDeserializer(deserializationContext, (JavaType)((Object)jsonDeserializer), beanDescription);
        }
        jsonDeserializer = this.findStdDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        if (!this.isPotentialBeanType(javaType.getRawClass())) {
            return null;
        }
        return this.buildBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    @Override
    public JsonDeserializer<Object> createBuilderBasedDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription, Class<?> clazz) throws JsonMappingException {
        JavaType javaType2 = deserializationContext.constructType(clazz);
        Object t = deserializationContext.getConfig().introspectForBuilder(javaType2);
        return this.buildBuilderBasedDeserializer(deserializationContext, javaType, (BeanDescription)t);
    }

    protected JsonDeserializer<?> findStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer = this.findDefaultDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationContext.getConfig(), beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected JavaType materializeAbstractType(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
            JavaType javaType2 = abstractTypeResolver.resolveAbstractType(deserializationContext.getConfig(), beanDescription);
            if (javaType2 == null) continue;
            return javaType2;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        ValueInstantiator valueInstantiator;
        try {
            valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new NoClassDefFoundDeserializer<Object>(noClassDefFoundError);
        }
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addObjectIdReader(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addReferenceProperties(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addInjectables(deserializationContext, beanDescription, beanDeserializerBuilder);
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object : this._factoryConfig.deserializerModifiers()) {
                beanDeserializerBuilder = object.updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        JsonDeserializer jsonDeserializer = javaType.isAbstract() && !valueInstantiator.canInstantiate() ? beanDeserializerBuilder.buildAbstract() : beanDeserializerBuilder.build();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> buildBuilderBasedDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addObjectIdReader(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addReferenceProperties(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addInjectables(deserializationContext, beanDescription, beanDeserializerBuilder);
        JsonPOJOBuilder.Value value = beanDescription.findPOJOBuilderConfig();
        String string = value == null ? "build" : value.buildMethodName;
        AnnotatedMethod annotatedMethod = beanDescription.findMethod(string, null);
        if (annotatedMethod != null && deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        beanDeserializerBuilder.setPOJOBuilder(annotatedMethod, value);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object : this._factoryConfig.deserializerModifiers()) {
                beanDeserializerBuilder = object.updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        JsonDeserializer<?> jsonDeserializer = beanDeserializerBuilder.buildBuilderBased(javaType, string);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected void addObjectIdReader(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        ObjectIdGenerator objectIdGenerator;
        JavaType javaType;
        SettableBeanProperty settableBeanProperty;
        Object object;
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        ObjectIdResolver objectIdResolver = deserializationContext.objectIdResolverInstance(beanDescription.getClassInfo(), objectIdInfo);
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            object = objectIdInfo.getPropertyName();
            settableBeanProperty = beanDeserializerBuilder.findProperty((PropertyName)object);
            if (settableBeanProperty == null) {
                throw new IllegalArgumentException("Invalid Object Id definition for " + beanDescription.getBeanClass().getName() + ": can not find property with name '" + object + "'");
            }
            javaType = settableBeanProperty.getType();
            objectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
        } else {
            object = deserializationContext.constructType(clazz);
            javaType = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object, ObjectIdGenerator.class)[0];
            settableBeanProperty = null;
            objectIdGenerator = deserializationContext.objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        }
        object = deserializationContext.findRootValueDeserializer(javaType);
        beanDeserializerBuilder.setObjectIdReader(ObjectIdReader.construct(javaType, objectIdInfo.getPropertyName(), objectIdGenerator, object, settableBeanProperty, objectIdResolver));
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        Iterator<BeanDeserializerModifier> iterator;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(this.findValueInstantiator(deserializationContext, beanDescription));
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        AnnotatedMethod annotatedMethod = beanDescription.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (annotatedMethod != null && (iterator = this.constructSettableProperty(deserializationContext, beanDescription, (BeanPropertyDefinition)((Object)(jsonDeserializer = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), (AnnotatedMember)annotatedMethod, new PropertyName("cause")))), annotatedMethod.getParameterType(0))) != null) {
            beanDeserializerBuilder.addOrReplaceProperty((SettableBeanProperty)((Object)iterator), true);
        }
        beanDeserializerBuilder.addIgnorable("localizedMessage");
        beanDeserializerBuilder.addIgnorable("suppressed");
        beanDeserializerBuilder.addIgnorable("message");
        if (this._factoryConfig.hasDeserializerModifiers()) {
            jsonDeserializer = this._factoryConfig.deserializerModifiers().iterator();
            while (jsonDeserializer.hasNext()) {
                iterator = jsonDeserializer.next();
                beanDeserializerBuilder = ((BeanDeserializerModifier)((Object)iterator)).updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        if ((jsonDeserializer = beanDeserializerBuilder.build()) instanceof BeanDeserializer) {
            jsonDeserializer = new ThrowableDeserializer((BeanDeserializer)jsonDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        return new BeanDeserializerBuilder(beanDescription, deserializationContext.getConfig());
    }

    protected void addBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        List<BeanPropertyDefinition> list;
        Object object22;
        Set<Object> set;
        SettableBeanProperty[] settableBeanPropertyArray = beanDeserializerBuilder.getValueInstantiator().getFromObjectArguments(deserializationContext.getConfig());
        boolean bl = !beanDescription.getType().isAbstract();
        JsonIgnoreProperties.Value value = deserializationContext.getConfig().getDefaultPropertyIgnorals(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        if (value != null) {
            boolean bl2 = value.getIgnoreUnknown();
            beanDeserializerBuilder.setIgnoreUnknownProperties(bl2);
            set = value.getIgnored();
            for (Object object22 : set) {
                beanDeserializerBuilder.addIgnorable((String)object22);
            }
        } else {
            set = Collections.emptySet();
        }
        AnnotatedMethod annotatedMethod = beanDescription.findAnySetter();
        Object object3 = null;
        if (annotatedMethod != null) {
            beanDeserializerBuilder.setAnySetter(this.constructAnySetter(deserializationContext, beanDescription, annotatedMethod));
        } else {
            object3 = beanDescription.findAnySetterField();
            if (object3 != null) {
                beanDeserializerBuilder.setAnySetter(this.constructAnySetter(deserializationContext, beanDescription, (AnnotatedMember)object3));
            }
        }
        if (annotatedMethod == null && object3 == null && (object22 = beanDescription.getIgnoredPropertyNames()) != null) {
            list = object22.iterator();
            while (list.hasNext()) {
                Iterator<BeanDeserializerModifier> iterator = (String)list.next();
                beanDeserializerBuilder.addIgnorable((String)((Object)iterator));
            }
        }
        boolean bl3 = deserializationContext.isEnabled(MapperFeature.USE_GETTERS_AS_SETTERS) && deserializationContext.isEnabled(MapperFeature.AUTO_DETECT_GETTERS);
        list = this.filterBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder, beanDescription.findProperties(), set);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object4 : this._factoryConfig.deserializerModifiers()) {
                list = object4.updateProperties(deserializationContext.getConfig(), beanDescription, list);
            }
        }
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            Serializable serializable;
            Object object;
            Serializable serializable2 = null;
            if (beanPropertyDefinition.hasSetter()) {
                object = beanPropertyDefinition.getSetter().getParameterType(0);
                serializable2 = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (JavaType)object);
            } else if (beanPropertyDefinition.hasField()) {
                object = beanPropertyDefinition.getField().getType();
                serializable2 = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (JavaType)object);
            } else if (bl3 && beanPropertyDefinition.hasGetter() && (Collection.class.isAssignableFrom((Class<?>)(serializable = ((AnnotatedMethod)(object = beanPropertyDefinition.getGetter())).getRawType())) || Map.class.isAssignableFrom((Class<?>)serializable))) {
                serializable2 = this.constructSetterlessProperty(deserializationContext, beanDescription, beanPropertyDefinition);
            }
            if (bl && beanPropertyDefinition.hasConstructorParameter()) {
                object = beanPropertyDefinition.getName();
                serializable = null;
                if (settableBeanPropertyArray != null) {
                    for (SettableBeanProperty settableBeanProperty : settableBeanPropertyArray) {
                        if (!((String)object).equals(settableBeanProperty.getName()) || !(settableBeanProperty instanceof CreatorProperty)) continue;
                        serializable = (CreatorProperty)settableBeanProperty;
                        break;
                    }
                }
                if (serializable == null) {
                    deserializationContext.reportMappingException("Could not find creator property with name '%s' (in class %s)", object, beanDescription.getBeanClass().getName());
                    continue;
                }
                if (serializable2 != null) {
                    ((CreatorProperty)serializable).setFallbackSetter((SettableBeanProperty)serializable2);
                }
                serializable2 = serializable;
                beanDeserializerBuilder.addCreatorProperty((SettableBeanProperty)serializable);
                continue;
            }
            if (serializable2 == null) continue;
            object = beanPropertyDefinition.findViews();
            if (object == null && !deserializationContext.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                object = NO_VIEWS;
            }
            serializable2.setViews((Class<?>[])object);
            beanDeserializerBuilder.addProperty((SettableBeanProperty)serializable2);
        }
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder, List<BeanPropertyDefinition> list, Set<String> set) throws JsonMappingException {
        ArrayList<BeanPropertyDefinition> arrayList = new ArrayList<BeanPropertyDefinition>(Math.max(4, list.size()));
        HashMap hashMap = new HashMap();
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            String string = beanPropertyDefinition.getName();
            if (set.contains(string)) continue;
            if (!beanPropertyDefinition.hasConstructorParameter()) {
                Class<?> clazz = null;
                if (beanPropertyDefinition.hasSetter()) {
                    clazz = beanPropertyDefinition.getSetter().getRawParameterType(0);
                } else if (beanPropertyDefinition.hasField()) {
                    clazz = beanPropertyDefinition.getField().getRawType();
                }
                if (clazz != null && this.isIgnorableType(deserializationContext.getConfig(), beanDescription, clazz, hashMap)) {
                    beanDeserializerBuilder.addIgnorable(string);
                    continue;
                }
            }
            arrayList.add(beanPropertyDefinition);
        }
        return arrayList;
    }

    protected void addReferenceProperties(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        Map<String, AnnotatedMember> map = beanDescription.findBackReferenceProperties();
        if (map != null) {
            for (Map.Entry<String, AnnotatedMember> entry : map.entrySet()) {
                String string = entry.getKey();
                AnnotatedMember annotatedMember = entry.getValue();
                JavaType javaType = annotatedMember instanceof AnnotatedMethod ? ((AnnotatedMethod)annotatedMember).getParameterType(0) : annotatedMember.getType();
                SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), annotatedMember);
                beanDeserializerBuilder.addBackReferenceProperty(string, this.constructSettableProperty(deserializationContext, beanDescription, simpleBeanPropertyDefinition, javaType));
            }
        }
    }

    protected void addInjectables(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        Map<Object, AnnotatedMember> map = beanDescription.findInjectables();
        if (map != null) {
            boolean bl = deserializationContext.canOverrideAccessModifiers();
            boolean bl2 = bl && deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
            for (Map.Entry<Object, AnnotatedMember> entry : map.entrySet()) {
                AnnotatedMember annotatedMember = entry.getValue();
                if (bl) {
                    annotatedMember.fixAccess(bl2);
                }
                beanDeserializerBuilder.addInjectable(PropertyName.construct(annotatedMember.getName()), annotatedMember.getType(), beanDescription.getClassAnnotations(), annotatedMember, entry.getKey());
            }
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationContext deserializationContext, BeanDescription beanDescription, AnnotatedMember annotatedMember) throws JsonMappingException {
        if (deserializationContext.canOverrideAccessModifiers()) {
            annotatedMember.fixAccess(deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        JavaType javaType = null;
        if (annotatedMember instanceof AnnotatedMethod) {
            javaType = ((AnnotatedMethod)annotatedMember).getParameterType(1);
        } else if (annotatedMember instanceof AnnotatedField) {
            javaType = ((AnnotatedField)annotatedMember).getType().getContentType();
        }
        javaType = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
        BeanProperty.Std std = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), javaType, null, beanDescription.getClassAnnotations(), annotatedMember, PropertyMetadata.STD_OPTIONAL);
        JsonDeserializer<Object> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedMember);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer<Object>)javaType.getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, std, javaType);
        }
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        return new SettableAnyProperty(std, annotatedMember, javaType, jsonDeserializer, typeDeserializer);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType) throws JsonMappingException {
        ObjectIdInfo objectIdInfo;
        AnnotationIntrospector.ReferenceProperty referenceProperty;
        AnnotatedMember annotatedMember = beanPropertyDefinition.getNonConstructorMutator();
        if (deserializationContext.canOverrideAccessModifiers()) {
            annotatedMember.fixAccess(deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        JavaType javaType2 = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        SettableBeanProperty settableBeanProperty = annotatedMember instanceof AnnotatedMethod ? new MethodProperty(beanPropertyDefinition, javaType2, typeDeserializer, beanDescription.getClassAnnotations(), (AnnotatedMethod)annotatedMember) : new FieldProperty(beanPropertyDefinition, javaType2, typeDeserializer, beanDescription.getClassAnnotations(), (AnnotatedField)annotatedMember);
        JsonDeserializer<?> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedMember);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer<?>)javaType2.getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, settableBeanProperty, javaType2);
            settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
        }
        if ((referenceProperty = beanPropertyDefinition.findReferenceType()) != null && referenceProperty.isManagedReference()) {
            settableBeanProperty.setManagedReferenceName(referenceProperty.getName());
        }
        if ((objectIdInfo = beanPropertyDefinition.findObjectIdInfo()) != null) {
            settableBeanProperty.setObjectIdInfo(objectIdInfo);
        }
        return settableBeanProperty;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition) throws JsonMappingException {
        AnnotatedMethod annotatedMethod = beanPropertyDefinition.getGetter();
        if (deserializationContext.canOverrideAccessModifiers()) {
            annotatedMethod.fixAccess(deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        JavaType javaType = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMethod, annotatedMethod.getType());
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        SettableBeanProperty settableBeanProperty = new SetterlessProperty(beanPropertyDefinition, javaType, typeDeserializer, beanDescription.getClassAnnotations(), annotatedMethod);
        JsonDeserializer<?> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedMethod);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer<?>)javaType.getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, settableBeanProperty, javaType);
            settableBeanProperty = ((SettableBeanProperty)settableBeanProperty).withValueDeserializer(jsonDeserializer);
        }
        return settableBeanProperty;
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        String string = ClassUtil.canBeABeanType(clazz);
        if (string != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        if (ClassUtil.isProxyType(clazz)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + clazz.getName() + " as a Bean");
        }
        string = ClassUtil.isLocalType(clazz, true);
        if (string != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig deserializationConfig, BeanDescription beanDescription, Class<?> clazz, Map<Class<?>, Boolean> map) {
        Boolean bl = map.get(clazz);
        if (bl != null) {
            return bl;
        }
        ConfigOverride configOverride = deserializationConfig.findConfigOverride(clazz);
        if (configOverride != null) {
            bl = configOverride.getIsIgnoredType();
        }
        if (bl == null) {
            BeanDescription beanDescription2 = deserializationConfig.introspectClassAnnotations(clazz);
            bl = deserializationConfig.getAnnotationIntrospector().isIgnorableType(beanDescription2.getClassInfo());
            if (bl == null) {
                bl = Boolean.FALSE;
            }
        }
        map.put(clazz, bl);
        return bl;
    }
}

