/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _generatorFactory;
    protected final GeneratorSettings _generatorSettings;
    protected final Prefetch _prefetch;

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        GeneratorSettings generatorSettings = this._generatorSettings = prettyPrinter == null ? GeneratorSettings.empty : new GeneratorSettings(prettyPrinter, null, null, null);
        if (javaType == null || javaType.hasRawClass(Object.class)) {
            this._prefetch = Prefetch.empty;
        } else {
            javaType = javaType.withStaticTyping();
            this._prefetch = Prefetch.empty.forRootType(this, javaType);
        }
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = GeneratorSettings.empty;
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = formatSchema == null ? GeneratorSettings.empty : new GeneratorSettings(null, formatSchema, null, null);
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, GeneratorSettings generatorSettings, Prefetch prefetch) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = generatorSettings;
        this._prefetch = prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        this._config = objectWriter._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, jsonFactory.requiresPropertyOrdering());
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        return new ObjectWriter(objectWriter, jsonFactory);
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        return new ObjectWriter(objectWriter, serializationConfig);
    }

    protected ObjectWriter _new(GeneratorSettings generatorSettings, Prefetch prefetch) {
        return new ObjectWriter(this, this._config, generatorSettings, prefetch);
    }

    protected SequenceWriter _newSequenceWriter(boolean bl, JsonGenerator jsonGenerator, boolean bl2) throws IOException {
        this._configureGenerator(jsonGenerator);
        return new SequenceWriter(this._serializerProvider(), jsonGenerator, bl2, this._prefetch).init(bl);
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withoutFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter with(JsonGenerator.Feature feature) {
        SerializationConfig serializationConfig = this._config.with(feature);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withFeatures(JsonGenerator.Feature ... featureArray) {
        SerializationConfig serializationConfig = this._config.withFeatures(featureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter without(JsonGenerator.Feature feature) {
        SerializationConfig serializationConfig = this._config.without(feature);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withoutFeatures(JsonGenerator.Feature ... featureArray) {
        SerializationConfig serializationConfig = this._config.withoutFeatures(featureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter with(FormatFeature formatFeature) {
        SerializationConfig serializationConfig = this._config.with(formatFeature);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withFeatures(FormatFeature ... formatFeatureArray) {
        SerializationConfig serializationConfig = this._config.withFeatures(formatFeatureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter without(FormatFeature formatFeature) {
        SerializationConfig serializationConfig = this._config.without(formatFeature);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withoutFeatures(FormatFeature ... formatFeatureArray) {
        SerializationConfig serializationConfig = this._config.withoutFeatures(formatFeatureArray);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter forType(JavaType javaType) {
        Prefetch prefetch = this._prefetch.forRootType(this, javaType);
        return prefetch == this._prefetch ? this : this._new(this._generatorSettings, prefetch);
    }

    public ObjectWriter forType(Class<?> clazz) {
        if (clazz == Object.class) {
            return this.forType((JavaType)null);
        }
        return this.forType(this._config.constructType(clazz));
    }

    public ObjectWriter forType(TypeReference<?> typeReference) {
        return this.forType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectWriter withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectWriter withType(Class<?> clazz) {
        return this.forType(clazz);
    }

    @Deprecated
    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.forType(typeReference);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = this._config.with(dateFormat);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(this._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        return filterProvider == this._config.getFilterProvider() ? this : this._new(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        GeneratorSettings generatorSettings = this._generatorSettings.with(prettyPrinter);
        if (generatorSettings == this._generatorSettings) {
            return this;
        }
        return this._new(generatorSettings, this._prefetch);
    }

    public ObjectWriter withRootName(String string) {
        SerializationConfig serializationConfig = (SerializationConfig)this._config.withRootName(string);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withRootName(PropertyName propertyName) {
        SerializationConfig serializationConfig = this._config.withRootName(propertyName);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withoutRootName() {
        SerializationConfig serializationConfig = this._config.withRootName(PropertyName.NO_NAME);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter with(FormatSchema formatSchema) {
        GeneratorSettings generatorSettings = this._generatorSettings.with(formatSchema);
        if (generatorSettings == this._generatorSettings) {
            return this;
        }
        this._verifySchemaType(formatSchema);
        return this._new(generatorSettings, this._prefetch);
    }

    @Deprecated
    public ObjectWriter withSchema(FormatSchema formatSchema) {
        return this.with(formatSchema);
    }

    public ObjectWriter withView(Class<?> clazz) {
        MapperConfigBase mapperConfigBase = this._config.withView((Class)clazz);
        return mapperConfigBase == this._config ? this : this._new(this, (SerializationConfig)mapperConfigBase);
    }

    public ObjectWriter with(Locale locale) {
        SerializationConfig serializationConfig = this._config.with(locale);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter with(TimeZone timeZone) {
        SerializationConfig serializationConfig = this._config.with(timeZone);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter with(Base64Variant base64Variant) {
        SerializationConfig serializationConfig = this._config.with(base64Variant);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter with(CharacterEscapes characterEscapes) {
        GeneratorSettings generatorSettings = this._generatorSettings.with(characterEscapes);
        if (generatorSettings == this._generatorSettings) {
            return this;
        }
        return this._new(generatorSettings, this._prefetch);
    }

    public ObjectWriter with(JsonFactory jsonFactory) {
        return jsonFactory == this._generatorFactory ? this : this._new(this, jsonFactory);
    }

    public ObjectWriter with(ContextAttributes contextAttributes) {
        SerializationConfig serializationConfig = this._config.with(contextAttributes);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withAttributes(Map<?, ?> map) {
        SerializationConfig serializationConfig = (SerializationConfig)this._config.withAttributes(map);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withAttribute(Object object, Object object2) {
        SerializationConfig serializationConfig = (SerializationConfig)this._config.withAttribute(object, object2);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withoutAttribute(Object object) {
        SerializationConfig serializationConfig = (SerializationConfig)this._config.withoutAttribute(object);
        return serializationConfig == this._config ? this : this._new(this, serializationConfig);
    }

    public ObjectWriter withRootValueSeparator(String string) {
        GeneratorSettings generatorSettings = this._generatorSettings.withRootValueSeparator(string);
        if (generatorSettings == this._generatorSettings) {
            return this;
        }
        return this._new(generatorSettings, this._prefetch);
    }

    public ObjectWriter withRootValueSeparator(SerializableString serializableString) {
        GeneratorSettings generatorSettings = this._generatorSettings.withRootValueSeparator(serializableString);
        if (generatorSettings == this._generatorSettings) {
            return this;
        }
        return this._new(generatorSettings, this._prefetch);
    }

    public SequenceWriter writeValues(File file) throws IOException {
        return this._newSequenceWriter(false, this._generatorFactory.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(JsonGenerator jsonGenerator) throws IOException {
        this._configureGenerator(jsonGenerator);
        return this._newSequenceWriter(false, jsonGenerator, false);
    }

    public SequenceWriter writeValues(Writer writer) throws IOException {
        return this._newSequenceWriter(false, this._generatorFactory.createGenerator(writer), true);
    }

    public SequenceWriter writeValues(OutputStream outputStream) throws IOException {
        return this._newSequenceWriter(false, this._generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(DataOutput dataOutput) throws IOException {
        return this._newSequenceWriter(false, this._generatorFactory.createGenerator(dataOutput), true);
    }

    public SequenceWriter writeValuesAsArray(File file) throws IOException {
        return this._newSequenceWriter(true, this._generatorFactory.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(JsonGenerator jsonGenerator) throws IOException {
        return this._newSequenceWriter(true, jsonGenerator, false);
    }

    public SequenceWriter writeValuesAsArray(Writer writer) throws IOException {
        return this._newSequenceWriter(true, this._generatorFactory.createGenerator(writer), true);
    }

    public SequenceWriter writeValuesAsArray(OutputStream outputStream) throws IOException {
        return this._newSequenceWriter(true, this._generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(DataOutput dataOutput) throws IOException {
        return this._newSequenceWriter(true, this._generatorFactory.createGenerator(dataOutput), true);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._generatorFactory.isEnabled(feature);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    public JsonFactory getFactory() {
        return this._generatorFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._prefetch.hasSerializer();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        this._configureGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            Closeable closeable = (Closeable)object;
            try {
                this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
                if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                    jsonGenerator.flush();
                }
            }
            catch (Exception exception) {
                ClassUtil.closeOnFailAndThrowAsIAE(null, closeable, exception);
                return;
            }
            closeable.close();
        } else {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public void writeValue(File file, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._generatorFactory.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._generatorFactory.createGenerator(writer), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) throws IOException {
        this._configAndWriteValue(this._generatorFactory.createGenerator(dataOutput), object);
    }

    public String writeValueAsString(Object object) throws JsonProcessingException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._generatorFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._generatorFactory.createGenerator(segmentedStringWriter), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) throws JsonProcessingException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._generatorFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._generatorFactory.createGenerator(byteArrayBuilder, JsonEncoding.UTF8), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider().acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        this.acceptJsonFormatVisitor(this._config.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider().hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        return this._serializerProvider().hasSerializerFor(clazz, atomicReference);
    }

    protected DefaultSerializerProvider _serializerProvider() {
        return this._serializerProvider.createInstance(this._config, this._serializerFactory);
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._generatorFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._generatorFactory.getFormatName());
        }
    }

    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        this._configureGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object);
            return;
        }
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIAE(jsonGenerator, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIAE(jsonGenerator, closeable, exception);
            return;
        }
        jsonGenerator.close();
    }

    protected final void _configureGenerator(JsonGenerator jsonGenerator) {
        this._config.initialize(jsonGenerator);
        this._generatorSettings.initialize(jsonGenerator);
    }

    public static final class Prefetch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Prefetch empty = new Prefetch(null, null, null);
        private final JavaType rootType;
        private final JsonSerializer<Object> valueSerializer;
        private final TypeSerializer typeSerializer;

        private Prefetch(JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) {
            this.rootType = javaType;
            this.valueSerializer = jsonSerializer;
            this.typeSerializer = typeSerializer;
        }

        public Prefetch forRootType(ObjectWriter objectWriter, JavaType javaType) {
            boolean bl;
            boolean bl2 = bl = javaType == null || javaType.isJavaLangObject();
            if (bl) {
                if (this.rootType == null || this.valueSerializer == null) {
                    return this;
                }
                return new Prefetch(null, null, this.typeSerializer);
            }
            if (javaType.equals(this.rootType)) {
                return this;
            }
            if (objectWriter.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
                DefaultSerializerProvider defaultSerializerProvider = objectWriter._serializerProvider();
                try {
                    JsonSerializer<Object> jsonSerializer = defaultSerializerProvider.findTypedValueSerializer(javaType, true, null);
                    if (jsonSerializer instanceof TypeWrappedSerializer) {
                        return new Prefetch(javaType, null, ((TypeWrappedSerializer)jsonSerializer).typeSerializer());
                    }
                    return new Prefetch(javaType, jsonSerializer, null);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return new Prefetch(null, null, this.typeSerializer);
        }

        public final JsonSerializer<Object> getValueSerializer() {
            return this.valueSerializer;
        }

        public final TypeSerializer getTypeSerializer() {
            return this.typeSerializer;
        }

        public boolean hasSerializer() {
            return this.valueSerializer != null || this.typeSerializer != null;
        }

        public void serialize(JsonGenerator jsonGenerator, Object object, DefaultSerializerProvider defaultSerializerProvider) throws IOException {
            if (this.typeSerializer != null) {
                defaultSerializerProvider.serializePolymorphic(jsonGenerator, object, this.rootType, this.valueSerializer, this.typeSerializer);
                return;
            }
            if (this.valueSerializer != null) {
                defaultSerializerProvider.serializeValue(jsonGenerator, object, this.rootType, this.valueSerializer);
                return;
            }
            defaultSerializerProvider.serializeValue(jsonGenerator, object);
        }
    }

    public static final class GeneratorSettings
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final GeneratorSettings empty = new GeneratorSettings(null, null, null, null);
        public final PrettyPrinter prettyPrinter;
        public final FormatSchema schema;
        public final CharacterEscapes characterEscapes;
        public final SerializableString rootValueSeparator;

        public GeneratorSettings(PrettyPrinter prettyPrinter, FormatSchema formatSchema, CharacterEscapes characterEscapes, SerializableString serializableString) {
            this.prettyPrinter = prettyPrinter;
            this.schema = formatSchema;
            this.characterEscapes = characterEscapes;
            this.rootValueSeparator = serializableString;
        }

        public GeneratorSettings with(PrettyPrinter prettyPrinter) {
            if (prettyPrinter == null) {
                prettyPrinter = NULL_PRETTY_PRINTER;
            }
            return prettyPrinter == this.prettyPrinter ? this : new GeneratorSettings(prettyPrinter, this.schema, this.characterEscapes, this.rootValueSeparator);
        }

        public GeneratorSettings with(FormatSchema formatSchema) {
            return this.schema == formatSchema ? this : new GeneratorSettings(this.prettyPrinter, formatSchema, this.characterEscapes, this.rootValueSeparator);
        }

        public GeneratorSettings with(CharacterEscapes characterEscapes) {
            return this.characterEscapes == characterEscapes ? this : new GeneratorSettings(this.prettyPrinter, this.schema, characterEscapes, this.rootValueSeparator);
        }

        public GeneratorSettings withRootValueSeparator(String string) {
            if (string == null ? this.rootValueSeparator == null : string.equals(this.rootValueSeparator)) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, string == null ? null : new SerializedString(string));
        }

        public GeneratorSettings withRootValueSeparator(SerializableString serializableString) {
            if (serializableString == null ? this.rootValueSeparator == null : this.rootValueSeparator != null && serializableString.getValue().equals(this.rootValueSeparator.getValue())) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, serializableString);
        }

        public void initialize(JsonGenerator jsonGenerator) {
            PrettyPrinter prettyPrinter = this.prettyPrinter;
            if (this.prettyPrinter != null) {
                if (prettyPrinter == NULL_PRETTY_PRINTER) {
                    jsonGenerator.setPrettyPrinter(null);
                } else {
                    if (prettyPrinter instanceof Instantiatable) {
                        prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
                    }
                    jsonGenerator.setPrettyPrinter(prettyPrinter);
                }
            }
            if (this.characterEscapes != null) {
                jsonGenerator.setCharacterEscapes(this.characterEscapes);
            }
            if (this.schema != null) {
                jsonGenerator.setSchema(this.schema);
            }
            if (this.rootValueSeparator != null) {
                jsonGenerator.setRootValueSeparator(this.rootValueSeparator);
            }
        }
    }
}

