/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListWriter;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import com.dd.plist.XMLPropertyListWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class PropertyListConverter {
    private PropertyListConverter() {
    }

    public static void convertToASCII(File file, File file2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject nSObject = PropertyListParser.parse(file);
        if (nSObject instanceof NSDictionary) {
            ASCIIPropertyListWriter.write((NSDictionary)nSObject, file2);
        } else if (nSObject instanceof NSArray) {
            ASCIIPropertyListWriter.write((NSArray)nSObject, file2);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array.");
        }
    }

    public static void convertToASCII(Path path, Path path2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject nSObject = PropertyListParser.parse(path);
        if (nSObject instanceof NSDictionary) {
            ASCIIPropertyListWriter.write((NSDictionary)nSObject, path2);
        } else if (nSObject instanceof NSArray) {
            ASCIIPropertyListWriter.write((NSArray)nSObject, path2);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array.");
        }
    }

    public static void convertToGnuStepASCII(File file, File file2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject nSObject = PropertyListParser.parse(file);
        if (nSObject instanceof NSDictionary) {
            ASCIIPropertyListWriter.writeGnuStep((NSDictionary)nSObject, file2);
        } else if (nSObject instanceof NSArray) {
            ASCIIPropertyListWriter.writeGnuStep((NSArray)nSObject, file2);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array.");
        }
    }

    public static void convertToBinary(File file, File file2) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        NSObject nSObject = PropertyListParser.parse(file);
        BinaryPropertyListWriter.write(nSObject, file2, true);
    }

    public static void convertToBinary(Path path, Path path2) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        NSObject nSObject = PropertyListParser.parse(path);
        BinaryPropertyListWriter.write(nSObject, path2);
    }

    public static void convertToXml(File file, File file2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject nSObject = PropertyListParser.parse(file);
        XMLPropertyListWriter.write(nSObject, file2);
    }

    public static void convertToXml(Path path, Path path2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject nSObject = PropertyListParser.parse(path);
        XMLPropertyListWriter.write(nSObject, path2);
    }
}

